/*
 * Decompiled with CFR 0.152.
 */
package com.android.product.data.repository;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.model.BaseResponse;
import com.android.core.domain.model.RequestData;
import com.android.files.data.repository.PictureInfoRepo;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.DbConnection;
import com.utility.Paging;
import com.utility.SoftwareInfo;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
public class ProductPicRepository
extends AndroidRepository<Map<String, Object>> {
    public ProductPicRepository(DbConnection dbConnection) {
        super(dbConnection);
    }

    public BaseResponse<Map<String, Object>> customQuery(RequestData request, Paging paging, LoginDto login) {
        String sql = this.makeSql(request, paging, login);
        PictureInfoRepo infoRepo = new PictureInfoRepo(this.dbConnection, login);
        List pics = infoRepo.generateJson(sql);
        return new BaseResponse.Builder().data(pics).totalCount(Integer.valueOf(pics.size())).totalPages(this.getTotalPages()).build();
    }

    @Nullable
    protected Paging.PageSqlData queryWithDefaultPaging(@NotNull SettingLoader settingsLoader) {
        if (settingsLoader.sendPicturesDisabled()) {
            return null;
        }
        SoftwareInfo softwareInfo = new SoftwareInfo(this.dbConnection.getJdbcTemplate(settingsLoader.getLogin()));
        boolean isArticleFromResMenuArt = softwareInfo.isRestaurant() && settingsLoader.isSendActiveResMenuProducts();
        boolean picIsSavedInDB = settingsLoader.picsSavedInDB();
        String packName = isArticleFromResMenuArt ? "RM.A_Type_Name" : "s.S_groupName";
        String select = " SELECT iai.[id] hloPicId, image_src + '_' + CAST(iai.id AS NVARCHAR) + '_' + A_CODE AS id, \n iai.picturePath filePath, " + packName + " AS packName, iai.[type] \n";
        select = picIsSavedInDB ? select + ", (CASE WHEN DataLength(iai.[picture]) > 1 THEN DataLength(iai.[picture]) ELSE -1 END) AS fileSize \n" : select + ", -1 AS fileSize \n";
        select = select + " FROM HLOPictures iai \n";
        String join = isArticleFromResMenuArt ? " RIGHT JOIN Res_MenuArt a ON iai.Code = a.A_Code \n INNER JOIN Res_MenuCategory RM On a.A_Type = RM.A_Type \n" : " RIGHT JOIN ARTICLE a ON iai.code = a.A_Code AND iai.[Type] = 1 \n INNER JOIN M_Group M ON SubString(A.A_Code, 1, 2) = M.M_GroupCode \n INNER JOIN S_Group S ON M.M_GroupCode = S.M_GroupCode \n  AND SubString(a.A_Code, 3, 2) = S.S_GroupCode \n";
        join = join + (settingsLoader.userHasLimitedAccessToProducts() ? " INNER JOIN(SELECT * FROM RMUserArtAccess \n WHERE UserId= " + settingsLoader.getLogin().getUserCodeInc() + ") RMUA ON RMUA.ArticleId = iai.code \n" : "");
        String where = "WHERE Code IS NOT NULL " + (!isArticleFromResMenuArt ? "AND ISNULL(a.UseInPortable, 0) = 1 " : "");
        return Paging.PageSqlData.builder().selectSqlStr(select).joinsStr(join).whereStr(where).alias("iai").keyField("hloPicId").build();
    }
}

